/*
  resource extraction routines
  written by alexander yaworsky
  '99
*/

#include <windows.h>

#include "paths.h"
#include "registry.h"
#include "sm.h"
#include "stdlib.h"
#include "resource.h"
#include "filetime.h"
#include "stringlist.h"
#include "syslog.h"
#include "switches.h"

BOOL ExtractFileFromResource( HANDLE FHandle, int ResType,
                              int ResId, DWORD* Sz )
  {
    DWORD    s, rs;
    unsigned char *RPtr;

    RPtr = (unsigned char*) SM_GetResource( ResType, ResId, &s );
    if( RPtr == NULL ) return FALSE;
    if( ! WriteFile( FHandle, RPtr, s, &rs, NULL ) ) {
      SysLog( "ExtractFileFromResource: WriteFile failed, error %d", GetLastError() );
      return FALSE;
    }
    if( Sz != NULL ) *Sz = s;
    return TRUE;
  }

BOOL ExtractFile( char* Path, int ResId )
  {
    SYSTEMTIME      Stm;
    HANDLE          Fh;
    char            K32Path[ MAX_PATH ];
    BOOL   Rc;

    Fh = CreateFile( Path, GENERIC_READ | GENERIC_WRITE,
                     0, NULL, OPEN_ALWAYS, 0, NULL );
    if( Fh == INVALID_HANDLE_VALUE ) {
      SysLog( "ExtractFile: CreateFile( %s ) failed, error %d", Path, GetLastError() );
      return FALSE;
    }
    SetEndOfFile( Fh );
    if( ExtractFileFromResource( Fh, RT_FILE, ResId, NULL ) ) {
      CloseHandle( Fh );
      GetKernel32Path( K32Path );
      GetLocalFileTime( K32Path, &Stm );
      SetLocalFileTime( Path, &Stm );
      Rc = TRUE;
    }
    else {
      CloseHandle( Fh );
      DeleteFile( Path );
      Rc = FALSE;
    }
    return Rc;
  }
